﻿using AZVIC.Ei8htPOS.Entities;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Data;

namespace AZVIC.Ei8htPOS.POSRetail.Converters
{
    public class DiscountConverter : BaseConverter, IValueConverter
    {

        public object Convert(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture)
        {
            OrdersDetails Orders = value as OrdersDetails;
            var switchParams = parameter as string;
            switch (switchParams)
            {

                case "dDisc":
                    if (!string.IsNullOrEmpty(Orders.DiscountType.Trim()))
                    {
                        //For Dollar Discount
                        if (Orders.DiscountType.Trim().ToLower() == "dollar")
                        {
                            var newAmount = Orders.OrderPrice - Orders.DiscountValue;
                            return string.Format("({0})", newAmount.ToString("0.00"));
                        }
                        else
                        {
                            var newAmount = Orders.OrderPrice - (Orders.OrderPrice * Orders.DiscountValue / 100);
                            return string.Format("({0})", newAmount.ToString("0.00"));
                        }
                    }
                    return string.Empty;

                case "dCost":
                    if (!string.IsNullOrEmpty(Orders.DiscountType.Trim()))
                    {
                        decimal newAmount;
                        //For Dollar Discount
                        if (Orders.DiscountType.Trim().ToLower() == "dollar")
                        {
                            newAmount = Orders.OrderPrice - Orders.DiscountValue;
                        }
                        else
                        {
                            newAmount = Orders.OrderPrice - (Orders.OrderPrice * Orders.DiscountValue / 100);
                        }
                        return string.Format("({0})", (newAmount * Orders.Quantity).ToString("0.00"));
                    }
                    else
                    {
                        return string.Empty;
                    }
            }
            return string.Empty;
        }

        public object ConvertBack(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture)
        {
            throw new NotImplementedException();
        }
    }
}
